/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.BreakChecks;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class BlockCorn
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public BlockCorn(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isLeaves = true;
        this.randomtick = true;
        this.maxdamage = 5;
        this.showInInventory = false;
        this.hasOwnRenderer = true;
        this.burntime = 15;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID && bid != Blocks.corn_plant.blockID && bid != Blocks.corn_plant1.blockID && bid != Blocks.corn_plant2.blockID && bid != Blocks.corn_plant3.blockID) {
            w.setblock(d, x, y, z, 0);
            if (this.blockID == Blocks.corn_plant3.blockID) {
                int i = w.rand.nextInt(3) + 1;
                int j = 0;
                while (j < i) {
                    EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (e != null) {
                        e.fill(Items.corn, 1);
                        w.spawnEntityInWorld(e);
                    }
                    Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    ++j;
                }
            }
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int d, int x, int y, int z) {
        if (this.blockID == Blocks.corn_plant3.blockID) {
            Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            return Items.corn.itemID;
        }
        return 0;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int bid;
        if (this.blockID != Blocks.corn_plant.blockID && this.blockID != Blocks.corn_plant1.blockID) {
            return;
        }
        int Height = 1;
        boolean dontGrow = false;
        if (w.rand.nextInt(14) != 1) {
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        int myMaxHeight = w.getblockmeta(d, x, y, z);
        if ((myMaxHeight &= 0xF) == 0) {
            myMaxHeight = 4 + w.rand.nextInt(4);
        }
        if ((bid = w.getblock(d, x, y + 1, z)) == 0) {
            int var6 = 1;
            while (var6 < 10) {
                bid = w.getblock(d, x, y - var6, z);
                if (bid != Blocks.corn_plant.blockID && bid != Blocks.corn_plant1.blockID && bid != Blocks.corn_plant2.blockID && bid != Blocks.corn_plant3.blockID) break;
                ++Height;
                if (bid == Blocks.corn_plant2.blockID || bid == Blocks.corn_plant3.blockID) {
                    dontGrow = true;
                }
                ++var6;
            }
            if (dontGrow) {
                myMaxHeight = Height;
            }
            if (Height < myMaxHeight) {
                w.setblockandmeta(d, x, y + 1, z, Blocks.corn_plant.blockID, myMaxHeight);
                w.setblockandmeta(d, x, y, z, Blocks.corn_plant1.blockID, myMaxHeight);
            } else {
                int i = 1;
                while (i < myMaxHeight - 1) {
                    bid = w.getblock(d, x, y - i, z);
                    if (bid == Blocks.corn_plant1.blockID && w.rand.nextInt(2) == 0) {
                        w.setblockandmeta(d, x, y - i, z, Blocks.corn_plant2.blockID, myMaxHeight);
                    } else if (bid == Blocks.corn_plant2.blockID && w.rand.nextInt(2) == 0) {
                        w.setblockandmeta(d, x, y - i, z, Blocks.corn_plant3.blockID, myMaxHeight);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(this.blockrenderwidth / 2.0f + (float)xo, -this.blockrenderwidth / 2.0f + (float)yo, -this.blockrenderwidth / 2.0f + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList(this.myrenderid, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex3f(-this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex3f(this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f);
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList(this.myrenderid);
    }
}

